/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity;

import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.coremod.colony.jobs.JobDruid;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DruidPotionEntity
extends PotionEntity {
    public static final double SPLASH_SIZE = 4.0;
    public static final double SPLASH_HEIGTH = 2.0;
    public static final double MAX_DISTANCE = 16.0;
    public static final int MIN_DURATION = 20;
    @Nullable
    private BiPredicate<LivingEntity, Effect> entitySelectionPredicate = null;

    public DruidPotionEntity(EntityType<? extends PotionEntity> type, World world) {
        super(type, world);
    }

    public void setEntitySelectionPredicate(@Nullable BiPredicate<LivingEntity, Effect> entitySelectionPredicate) {
        this.entitySelectionPredicate = entitySelectionPredicate;
    }

    public void func_213888_a(@NotNull List<EffectInstance> effects, @Nullable Entity entity) {
        AxisAlignedBB axisalignedbb;
        List list;
        AbstractEntityCitizen citizen = this.getOwner();
        if (citizen != null && citizen.getCitizenData() != null && citizen.getCitizenData().getJob() instanceof JobDruid && !(list = this.field_70170_p.func_217357_a(LivingEntity.class, axisalignedbb = this.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0))).isEmpty()) {
            for (LivingEntity livingentity : list) {
                double distanceSq;
                if (!livingentity.func_184603_cC() || !((distanceSq = this.func_70068_e((Entity)livingentity)) < 16.0)) continue;
                double d1 = 1.0 - Math.sqrt(distanceSq) / 4.0;
                if (livingentity == entity) {
                    d1 = 1.0;
                }
                for (EffectInstance effectinstance : effects) {
                    Effect effect = effectinstance.func_188419_a();
                    if (this.entitySelectionPredicate != null && !this.entitySelectionPredicate.test(livingentity, effect)) continue;
                    if (effect.func_76403_b()) {
                        effect.func_180793_a((Entity)this, (Entity)this.getOwner(), livingentity, effectinstance.func_76458_c(), d1);
                        continue;
                    }
                    int duration = (int)(d1 * (double)effectinstance.func_76459_b());
                    livingentity.func_195064_c(new EffectInstance(effect, duration, effectinstance.func_76458_c(), effectinstance.func_82720_e(), effectinstance.func_188418_e()));
                }
            }
        }
    }

    @Nullable
    public AbstractEntityCitizen getOwner() {
        Entity owner = super.func_234616_v_();
        if (owner instanceof AbstractEntityCitizen) {
            return (AbstractEntityCitizen)owner;
        }
        return null;
    }

    public static void throwPotionAt(ItemStack potionStack, LivingEntity target, AbstractEntityCitizen thrower, World world, float velocity, float inaccuracy, BiPredicate<LivingEntity, Effect> entitySelectionPredicate) {
        DruidPotionEntity potionentity = (DruidPotionEntity)ModEntities.DRUID_POTION.func_200721_a(world);
        potionentity.func_212361_a((Entity)thrower);
        potionentity.setEntitySelectionPredicate(entitySelectionPredicate);
        potionentity.func_213884_b(potionStack);
        potionentity.func_70107_b(thrower.func_226277_ct_(), thrower.func_226278_cu_() + 1.0, thrower.func_226281_cx_());
        thrower.field_70170_p.func_184148_a(null, thrower.func_226277_ct_(), thrower.func_226278_cu_(), thrower.func_226281_cx_(), SoundEvents.field_187924_gx, thrower.func_184176_by(), 1.0f, 0.8f + thrower.func_70681_au().nextFloat() * 0.4f);
        Vector3d movement = target.func_213322_ci();
        double x = target.func_226277_ct_() + movement.field_72450_a - thrower.func_226277_ct_();
        double y = target.func_226280_cw_() - (double)1.1f - thrower.func_226278_cu_();
        double z = target.func_226281_cx_() + movement.field_72449_c - thrower.func_226281_cx_();
        double distance = MathHelper.func_76133_a((double)(x * x + z * z));
        potionentity.func_70186_c(x, y + distance * 0.2, z, velocity, inaccuracy);
        world.func_217376_c((Entity)potionentity);
    }

    @NotNull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

